# other files to include:
# c_defines.asm (required)
# s_defines.asm (required)
# c_capcom.asm
# s_capcom.asm
# c_filetext.asm
# s_filetext.asm

00/:
	define wCurrentEffect,c6a0
	define wPreviousEffect,c6a1

# make start button set A item to bracelet if not bracelet, else feather.
# make select button toggle pegasus seeds.
02/overrideMenus:
	cp a,01
	jr nz,.next
	ld hl,c681
	ld a,TREASURE_BRACELET
	cp (hl)
	jr nz,.notBracelet
	ld a,01
	ld (wFeatherLevel),a
	ld a,(c694)
	or a,80
	ld (c694),a # need to set this again in case H&S takes feather
	ld a,TREASURE_FEATHER
.notBracelet
	ld (hl),a
	ld hl,wStatusBarNeedsRefresh
	set 0,(hl)
	ret
.next
	cp a,02
	jr nz,.next2
	ld hl,wPegasusSeedCounter
	inc hl
	ld a,(hl)
	and a
	jr nz,.turnOff
	ld (hl),7f
	ret
.turnOff
	xor a
	ldd (hl),a
	ld (hl),a
	ret
.next2
	ld hl,cbcb
	jp 4f32
02/4f2f/:
	jp overrideMenus

# open chests as many times as you want! (after resetting the room.)
04/5f58/:
	ret

# make link actionable as soon as he drops into the world.
05/4d98/:
	jp setLinkIdOverride

# make maple always use the rare pattern that drops better stuff. useful for potion
05/6986/:
	dw 6988

# rod of seasons behavior
06/useRodSpecial:
	push bc
	push de
	push hl
	ld a,(wCurrentEffect)

	cp a,TREASURE_BOMBS
	jr nz,.notBombs
	ld hl,d008
	ld a,(hl)
	ld l,0b
	ld b,(hl)
	ld l,0d
	ld c,(hl)
	ld hl,directionOffsets
	rst 18 # addDoubleIndex
	ldi a,(hl)
	add a,b
	ld b,a
	ld a,(hl)
	add a,c
	ld c,a
	ld e,1f
.breakLoop
	push bc
	push de
	call tryToBreakTile
	pop de
	pop bc
	jr c,.done
	dec e
	ld a,e
	cp a,ff
	jr z,.done
	jr .breakLoop
.notBombs


	cp a,TREASURE_GALE_SEEDS
	jr nz,.notSatchel
	ld c,00
	jr .seed
.notSatchel
	cp a,TREASURE_EMBER_SEEDS
	jr z,.slingshot
	cp a,TREASURE_SCENT_SEEDS
	jr z,.slingshot
	cp a,TREASURE_MYSTERY_SEEDS
	jr z,.slingshot
	jr .notSlingshot
.slingshot
	ld c,01
.seed
	ld b,a
	ld e,19
	ld a,d0
	ld (de),a
	ld e,01
	call 5335 # itemCreateChildWithID
	jr .done
.notSlingshot

	cp a,TREASURE_PEGASUS_SEEDS
	jr nz,.notPegasus
	ld a,(d00f)
	dec a
	add a,10 # only allow while near ground
	jr nc,.done
	ld hl,d014
	inc hl
	ldd a,(hl)
	sub a,80 # only allow while falling
	jr nc,.done
	ld bc,fdd0
	ld (hl),c
	inc hl
	ld (hl),b
	ld a,01
	ld (wLinkInAir),a
	jr .done
.notPegasus

	cp a,TREASURE_RUPEES
	jr nz,.notRupees
	call 4c66 # createSwordBeam
	jr .done
.notRupees

.done
	pop hl
	pop de
	pop bc
	ld a,(ccb6)
	ret
06/directionOffsets:
	db f0,00 # up
	db 00,10 # right
	db 10,00 # down
	db 00,f0 # left
06/4a56/:
	call useRodSpecial

# skip intro and start with rod, bracelet, and feather.
07/initFile:
	call 416e

	# equips
	ld hl,c680
	ld a,TREASURE_ROD_OF_SEASONS
	ldi (hl),a
	ld a,TREASURE_BRACELET
	ldi (hl),a

	# inventory flags
	ld hl,wObtainedTreasureFlags
	ld a,TREASURE_ROD_OF_SEASONS
	call setFlag
	ld a,TREASURE_BRACELET
	call setFlag
	ld a,TREASURE_FEATHER
	call setFlag

	ld a,01
	ld (wFeatherLevel),a

	# global flags
	ld a,0a
	call setGlobalFlag
	ld a,1c
	call setGlobalFlag

	# room flags
	ld a,50
	ld (c7a7),a # start
	ld a,c0
	ld (c798),a # troupe
	ld a,40
	ld (c7b6),a # impa's house

	ret
07/400d/:
	call initFile

# use winter as initial season, since intro is skipped.
07/4188/:
	db 2d,03

# if rod effect is ore, use fool's ore collision & damage.
# if rod effect is hearts (fairy), use spin slash.
07/alterRodCollision:
	ld e,a
	cp a,0e
	jr nz,.done
	ld a,(wCurrentEffect)
	cp a,TREASURE_HEART_REFILL
	jr nz,.notFairy
	ld a,TREASURE_SWORD
	add a,a
	ld e,a
	jr .done
.notFairy
	cp a,TREASURE_ORE_CHUNKS
	jr nz,.done
	ld a,TREASURE_FOOLS_ORE
	add a,a
	ld e,a
.done
	ld a,e
	ld hl,6351
	ret
07/497f/:
	call alterRodCollision

# sword collision data (make normal slash into spin attack)
07/6365/:
	db 88,00,fc,7e

# allow buying bombs, hearts from shop at full
08/4a80/:
	ret

# always return "false" for a certain type of room bit 5 check
0b/4105/:
	ld b,00

# allow buying ember seeds from scrub at full
0f/755b/:
	jr 18

# allow buying bombs from scrub at full
0f/7567/:
	jr 0c

# no blaino, because of equip problems
11/66cb/:
	db ff

14/71f0/dma_FileSelectStringTiles:
	# OOS HACK NOV26.0
	db 74,31,f0,f0,f4,fc,e9,e2,e4,ec,fc,ef,f0,f7,12,16,ff,10,41,40
	db 02,02,02,02,02,02,02,02,02,02,02,02 # offscreen
	# "EPHEMERA"
	db 40,41,00,00,00,fd,e6,f1,e9,e6,ee,e6,f3,e2,fe,00,00,00,51,50
	db 02,02,02,02,02,02,02,02,02,02,02,02 # offscreen

# always use gbc palettes.
3f/403b/:
	xor a
	nop

# change rod power based on last item pickup.
# heart refill reverts to previous effect.
3f/changeRodEffect:
	ld hl,wCurrentEffect
	push bc
	ld b,a
	cp a,TREASURE_BOMBS
	jr z,.match
	cp a,TREASURE_EMBER_SEEDS
	jr z,.match
	cp a,TREASURE_SCENT_SEEDS
	jr z,.match
	cp a,TREASURE_PEGASUS_SEEDS
	jr z,.match
	cp a,TREASURE_GALE_SEEDS
	jr z,.match
	cp a,TREASURE_MYSTERY_SEEDS
	jr z,.match
	cp a,TREASURE_RUPEES
	jr z,.match
	cp a,TREASURE_HEART_REFILL
	jr z,.hearts
	cp a,TREASURE_ORE_CHUNKS
	jr z,.match
	jr .done
.hearts
	# fairy actually does set effect.
	ld a,c
	cp a,18
	jr z,.match
	# otherwise swap current item and previous item.
	ldi a,(hl)
	ld b,(hl)
	ldd (hl),a
	ld (hl),b
	jr .done
.match
	# push current item to previous item, and replace current item.
	# …unless the new item is the same as the current item.
	ldi a,(hl)
	cp b
	jr z,.done
	ldd (hl),a
	ld (hl),b
.done
	pop bc
	ld hl,4544
	ret
3f/44ce/:
	call changeRodEffect

# when obtaining any item that can be equipped, equip it on the A button.
3f/46e6/:
	push hl
	ld hl,wStatusBarNeedsRefresh
	set 0,(hl)
	pop hl
	inc hl
	jr 07
