#!/usr/bin/env bash

# create zip files for distribution on the three major OSes
#
# strictly speaking nothing here should need quoting but that's just my
# environment

set -euo pipefail

python3 scripts/checklist.py
python3 scripts/markdown-toc doc/manual.md > manual.html
awk '{printf "%s\r\n", $0}' doc/manual.md > manual.txt

version="$(grep -o '".\+"' randomizer/version.go | tr -d '"')"
appname="$(basename "$PWD")"

mkdir -p "dist/$version"
dir="$appname"-"$version"

function buildfor() {
	echo "building for $1/$2"
	CGO_ENABLED=0 GOOS=$1 GOARCH=$2 go build
	strip "$appname$4" || true  # ignore errors for formats we can't strip
	mkdir "$dir"
	cp -r "$appname$4" Oracles.lua manual.html manual.txt checklist/ tracker/ \
		"$dir"
	zip -qr "dist/$version/$appname"-"$version"-"$3.zip" "$dir"
	rm -rd "$dir"
}

buildfor windows 386 windows-x86 .exe
buildfor windows amd64 windows-x64 .exe
buildfor windows arm64 windows-arm64 .exe
buildfor darwin amd64 macos-x64 ''
buildfor darwin arm64 macos-arm64 ''
buildfor linux 386 linux-x86 ''
buildfor linux amd64 linux-x64 ''
buildfor linux arm linux-arm ''
buildfor linux arm64 linux-arm64 ''

rm manual.*

# source archive
mkdir -p "$dir"
cp -r `fossil ls | sed 's;/.\+;;' | uniq` "$dir"
find "$dir" -name '.*' -delete
zip -qr "dist/$version/$appname"-"$version".zip "$dir"
rm -rd "$dir"

echo "archives written to dist/$version/"
