#!/usr/bin/env python3

import os
import re
import sys

# create an HTML checklist (doc/checklist.html) from the logic. this must be
# run from the repository's root folder.

files = {
    'seasons': 'romdata/seasons_slots.yaml',
    'ages': 'romdata/ages_slots.yaml',
}

version_regexp = re.compile('const version = "(.+?)"')
slot_regexp = re.compile('"(.+?)": +(And|Or)Slot')
name_regexp = re.compile('"(.+?)": +"(.+?)",')

doc_template = """<!DOCTYPE html>
<html>
<style>
/* body { font-family: sans-serif; } */
h1 { font-size: x-large; text-align: center; }
/* h2 { font-size: large; } */
main { column-width: 13rem; column-gap: 0; }
</style>
<head>
<title>Oracles Randomizer %s - %s checklist</title>
</head>
<body>
<h1>Oracles Randomizer %s - %s checklist</h1>
<main>
%s
</main>
</body>
</html>
"""

with open('randomizer/version.go') as f:
    for line in f.readlines():
        match = version_regexp.match(line)
        if match:
            version = match.group(1)
            break

names = {}
with open('randomizer/names.go') as f:
    for line in f.readlines():
        match = name_regexp.search(line)
        if match:
            names[match.group(1)] = match.group(2)

def make_checklist(game, infile, outfile):
    elements = []
    with open(infile) as f:
        for line in f.readlines():
            if (m := re.match(r'^([^#:]+):$', line)):
                elements.append('<input type="checkbox"> ' + m.group(1))
    outfile.write(doc_template %
        (version, game, version, game.capitalize(), '<br>\n'.join(elements)))

os.makedirs('checklist', exist_ok=True)
for game, infiles in files.items():
    with open('checklist/%s.html' % game, 'w') as outfile:
        make_checklist(game, infiles, outfile)
