package randomizer

import (
	"embed"
	"os"
	"testing"

	"gopkg.in/yaml.v2"

	"jangle.dev/fossil/oracles-randomizer/asm"
	"jangle.dev/fossil/oracles-randomizer/hints"
	"jangle.dev/fossil/oracles-randomizer/logic"
	"jangle.dev/fossil/oracles-randomizer/romdata"
)

func TestLoadYaml(t *testing.T) {
	// make sure all yaml files are well-formed.
	fses := []embed.FS{asm.FS, hints.FS, logic.FS, romdata.FS}
	for _, fs := range fses {
		// get list of files in directory
		dir, err := fs.ReadDir(".")
		if err != nil {
			t.Fatal(err)
		}
		files := make([]os.FileInfo, len(dir))
		for i, entry := range dir {
			files[i], err = entry.Info()
			if err != nil {
				t.Fatal(err)
			}
		}

		for _, file := range files {
			name := file.Name()

			// either a slice or a map should work
			m := make(map[interface{}]interface{})
			mapErr := yaml.Unmarshal(fsMustByte(fs, name), &m)
			a := make([]interface{}, 0)
			sliceErr := yaml.Unmarshal(fsMustByte(fs, name), &a)

			if mapErr != nil && sliceErr != nil {
				t.Errorf("failed to unmarshal %s into map or slice", name)
				t.Error(mapErr)
				t.Error(sliceErr)
			}
		}
	}
}
