# Oracles Randomizer manual

This program reads a Zelda: Oracle of Seasons or Oracle of Ages ROM (US
versions only), shuffles the locations of (most) items and mystical seeds, and
writes the modified ROM to a new file. In Seasons, the default seasons for each
area are also randomized. Most arbitrary checks for essences and other game
flags are removed, so the dungeons and other areas can be done in any order
that the randomized items facilitate. However, you do need to collect all 8
essences to get the Maku Seed and finish the game.

## Usage

There are three ways to use the randomizer:

1. Place the randomizer in the same directory as your vanila ROM(s) (or vice
   versa), and run it. The randomizer will automatically find your vanilla
   ROM(s) and prompt for further options.
2. In Windows, drag your vanilla ROM onto the executable. (In this case, the ROM
   and randomizer don't have to be in the same folder.)
3. Use the command line. Type `./oracles-randomizer -h` to view the usage
   summary.

The randomizer also has a [web
interface](https://cemulate.github.io/oracles-randomizer-web), contributed by
[cemulate](https://github.com/cemulate).

You may also be interested in [Oracles Randomizer
Extras](https://jangle.dev/oracles-randomizer/extras/).

## Getting help

If you're having trouble figuring out what to do in your randomized game, there
are a couple of ways to get help:

1. Try [EmoTracker](https://emotracker.net/), using the pack developed by
   Herreteman. You tell the EmoTracker which items you have and other details
   about your randomized game, and it tells you which item locations you have
   access to.
2. Ask in the [Oracles Discord server](https://discord.gg/pyBEbz5). Make sure
   to use the randomizer-specific channels; the other channels are more for
   speedrunning.

If you think you've found a bug or other issue in the randomizer, please report
it using the [issue
tracker](https://jangle.dev/fossil/oracles-randomizer/ticket).

## Misc. notes

- Do not use VisualBoyAdvance to play the randomizer. VBA has serious emulation
  bugs that can cause crashes and other problems. BGB, mGBA, Bizhawk, and
  Gambatte are better emulation options.
- Not all linked game content is supported by the randomizer (and none of it is
  randomized).
- Several other versions of the randomizer exist, most derived from this
  original codebase and further developed by other authors. For more
  information, refer to <https://jangle.dev/oracles-randomizer/>.

## Randomization

General details common to both games:

- Items and chests are randomized, with these exceptions:
    - Renewable shop and business scrub items (bombs, shield, hearts, etc.)
	- Gasha seeds and pieces of heart outside of chests
	- NPCs that give non-progression items in the vanilla game
	- Gasha nut contents
	- Fixed drops (from bushes, pots, etc.)
	- Maple drops
	- Linked secrets
- Mystical seed trees are randomized, with no more than two trees of each type.
  Items that use seeds for ammunition start with the type of seed that's on the
  Horon Village or Lynna City tree.
- For items that have multiple levels, the first you obtain will be L-1, and the
  second will be L-2, regardless of the order in which you obtain them. The L-2
  shield is an exception.
- There is one flute in the game for a random animal companion, and it's
  identified and usable as soon as you get it. Only the 150-rupee item in the
  shop is randomized; the other two usual means of getting a strange flute
  don't give anything special. The animal companion regions (Natzu in Seasons
  and Nuun in Ages) match whatever flute is in the seed.
- Rings are instantly appraised when you get them, and the ring list can be
  accessed from the inventory ring box icon. For convenience, the L-3 ring box
  is given at the start. The punch rings can be used with only one equip slot
  empty.
- Select+right on the file select screen toggles music. Select+left on the file
  select screen toggles between GBC palettes (default) and lighter GBA
  palettes. This will only have an effect if you're playing on or emulating a
  GBA.
- If tree warp is enabled, holding start while closing the map screen outdoors
  warps to the seed tree in Horon Village or Lynna City. Think carefully before
  using tree warp, since there may be situations where it could get you into
  trouble.
- If hard difficulty is enabled, speedrun-level tricks and obscure knowledge
  may be required to complete the game. Use normal difficulty if you just want
  to do a casual playthrough!

### Ages

#### Items and item locations

- The harp is progressive, starting with the Tune of Echoes, then Currents,
  then Ages.
- The trading sequence is removed. The second sword is in the item pool, and
  the Poe in Yoll Graveyard gives a randomized item.
- The red soldier who takes you to Ambi's palace for bombs waits in Deku Forest
  instead. Talk to him to trade mystery seeds for an item.
- The first **and** second prizes for Target Carts are randomized. Only the
  first item for each other minigame is randomized, with the exception of the
  Lynna Village Shooting Gallery, which has no randomized prize since its
  normal prize is a strange flute.
- Past and present versions of the same mystical seed tree grow the same type
  of seed.
- The secret shop items are not randomized.

#### Other notable changes

- The intro sequence is removed. A chest replaces Impa on the screen where she
  normally gives the sword.
- The time portals on the screens adjacent to the Maku Tree are active
  permanently.
- The Tokays on Crescent Island do not steal your items, and the raft does not
  encounter a storm in the Sea of Storms.
- Dormant time portals are added to Nuun Highlands and Symmetry Village past in
  order to prevent softlocks.
- The dormant portal on the west side of Crescent Island present only responds
  to Currents, not Echoes, in order to prevent softlocks. The sign says so.
- Playing the Tune of Currents triggers reentry into a return portal Link is
  standing on. This is useful if you warp into a patch of bushes without a
  bush-breaking item.
- Ambi's palace courtyard is open from the beginning.

### Seasons

#### Items and item locations

- The default season for each area is randomized, with the exception of regions
  that have only one season anyway.
- The rod of seasons is broken into four items (one for each season). Obtaining
  a season gives you the rod as well.
- Fool's ore is randomized, since it's actually the most powerful weapon in the
  game. The Strange Brothers trade you nothing for your feather (or cape), and
  shovel is not required to retrieve the stolen item.

The following items are **not** randomized:

- Pirate's bell (obtained by polishing the rusty bell)
- Subrosian dancing prizes after the first
- Subrosian hide and seek items
- Trading sequence items, since the vanilla trading sequence reward is
  technically just a text box and not an item.

#### Other notable changes

- The intro sequence is removed, dropping you just north of Horon Village
  at the start of the game instead.
- Mystical seeds grow in all seasons.
- Rosa doesn't appear in the overworld, and her portal is activated by default.
- In some situations, the game will give you a warning about what you're doing
  or about to do. **If you receive one, what you're doing is out of logic and
  could potentially lead to a softlock**—but in some cases you can also be fine
  as long as you're careful.

## Logic

"Logic" means the set of plays that the randomizer may require you to make in
order to progress in the game. Anything the vanilla game requires you to do is,
of course, in logic. Additionally, "normal logic" documents things that may be
required in any seed, and "hard logic" documents things that may be required in
hard mode seeds. Anythingn "out of logic" is never required.

### Ages

#### Normal logic

- Jumping over 2 tiles with feather, or 3 tiles with feather + pegasus seeds
  (subtract 1 tile if the jump is over water or lava instead of a pit)
- Using only ember seeds from the seed satchel as a weapon
- Using only ember, scent, or gale seeds from the seed shooter as a weapon
- Using expert's ring as a weapon
- Using thrown objects (bushes, pots) as weapons
- Flipping spiked beetles using the shovel
- Farming rupees for minigames

#### Hard logic

- Required damage (damage boosts, falling in pits)
- Farming rupees using the shovel (large rupees can be RNG manipulated)
- Getting initial scent seeds from the plants in D3
- Getting initial bombs from Goron Shooting Gallery or Head Thwomp
- Lighting torches using mystery seeds
- Using only scent or gale seeds from the seed satchel as a weapon
- Using fist ring as a weapon
- Carrying bushes or pots between rooms
- Doing Patch's restoration ceremony without sword
- Getting a potion for King Zora from Maple instead of Syrup
- Guard skip

#### Out of logic

- Farming rupees for shop purchases without a shovel
- Getting initial scent seeds from the D7 miniboss
- Mystery seeds as a weapon
- Bombs as a weapon, except versus enemies immune to sword
- Double damage boosts
- Text warps
- Clipping into fairies' woods by switch hooking the Octorok
- Trading scent seeds for a shield without having a seed item
- Magic rings from non-randomized locations
- Linked secrets

#### Strategy guide

##### Overworld present

- RNG manip 100-rupee drops using the shovel, for infinite rupees in logic.
  Hard reset, mash through the title screen (it rolls RNG every frame), make 7
  screen transitions, and dig until the 100-rupee drop.
  [[Video]](https://imgur.com/d7DXw1T)
- Hit the switch in the cave under Tingle using a bomb/seed jump + boomerang.
  [[Video]](https://imgur.com/oFWQkty)
- Hit the switch in the cave under Tingle using the seed shooter, coming from
  the stairs. The position is subpixel-dependent, so run around diagonally a
  bit if you're on the correct pixel and the seed is breaking on one of the
  green tiles.
- Reach the Crescent Island seed tree by visiting the map tile underwater, then
  warping to it with gale seeds. [[Video]](https://imgur.com/aIYSznK)

##### Overworld past

- Patch swordless: push into a corner until all beetles are stacked together,
  then use shield, shovel, scent seeds, switch hook, or boomerang.
  [[Video]](https://imgur.com/EQ5sKXQ)
- Enter D6 past and cross the main waterway in Rolling Ridge Base by jumping
  into and out of the waterfall. Entering from either direction and exiting to
  the left only require a bomb jump, but exiting to the right requires pegasus
  seeds. [[Video]](https://imgur.com/VOFhLXo)
- Guard skip: Enter Ambi's palace by using pegasus seeds, dropping a scent seed
  on the ground to alert the guards at the entrance, waiting a moment, then
  running past them. Some people use a sword slash to time the duration of the
  wait. [[Video]](https://imgur.com/RYv3tJV)
- Use a bomb+seed jump to reach the final book in the library trial without
  using the Book of Seals. [[Video]](https://imgur.com/CJUnM1J)

##### Dungeons

- Reach the item on a "shelf" in the D2 sidescroller by placing a block with
  the cane, riding the Thwomp, and using seeds, a bomb boost, or a sword clink
  to cross the gap. [[Video (seed)]](https://imgur.com/WvhLkeV)
  [[Video (bomb)]](https://www.youtube.com/watch?v=2BwkmYC3mt0)
  [[Video (sword)]](https://clips.twitch.tv/CalmMoralSushiDAESuppy)
- Clip through a shutter door in D2 by standing on the button that opens the
  door, pushing a Moblin into the doorway, and switching with the Moblin. You
  need to screen transition immediately after landing; otherwise you'll be
  treated as if falling into a pit. [[Video]](https://imgur.com/MlG2BsD)
- Break the northwest crystal in D3 using the switch hook.
  [[Video]](https://imgur.com/Npbaxgl)
- Hit the lever for the vanilla D3 boss key chest using a spin slash through
  the wall. [[Video]](https://imgur.com/z33pbqo)
- Hit levers for the bridges in D3 by:
	1. Using boomerang + seeds or feather in the first room.
	2. Using a bush + bracelet + toss ring + seeds or feather + a pot in the
	   first room.
	3. Using feather + sword + switch hook in the second room.
	4. Using feather + sword + a pot + bracelet in the second room.
	5. Using seeds/bombs + feather + ember/scent/mystery seeds from satchel in
	   the second room.

  [[Video (1, 2)]](https://imgur.com/UlsnuZk)
  [[Video (3, 4, 5 w/o bomb boost)]](https://imgur.com/NQqydo1)
  [[Video (5 w/ bomb boost)]](https://clips.twitch.tv/LazyImpartialLadiesMVGame)
- Get two chests in D4 by hitting switches with feather + boomerang instead of
  seed shooter. [[Video]](https://imgur.com/6VwIghQ)
- Skip switch hook in D4 by taking the miniboss portal, bomb jumping to the
  bridge from the first minecart track, using cane to press the button
  downstairs, and breaking the pot using noble sword.
- Hit two switches in D5 from a distance by throwing pots. The second throw
  requires the toss ring, plus feather (+ seeds?) to cross the next barrier.
  [[Video]](https://imgur.com/WECGE2Q)
- Hit the second switch in D5 (from above video) using ember/scent/mystery
  seeds + satchel, using feather and cane to clip through the red pegs.
  [[Video]](https://clips.twitch.tv/RefinedBlightedPuffinPupper)
- Hit the three eye statues in D5 by using pegasus seeds, feather, and
  mystery seeds from satchel. [[Video]](https://imgur.com/qm40r17)
- Hit the switch in D5 before the two-statue puzzle using bomb jump + satchel +
  ember/scent/mystery seeds.
- Cross the bridge in D5 with seed + feather jumps, or by RNG manipulating the
  Darknut across the bridge using sword, then switch hooking it. The last two
  sword slashes before transitioning to the bridge room should be high pitch,
  then mid pitch. [[Video]](https://imgur.com/GFhmX7G)
- Change the colors of gels in the D6 past color room by using mystery seeds
  instead of jumping over the panel.
- Walk diagonally across the corners of pits in the D6 present cube puzzle.
- Use feather + sword to traverse the D6 present room with the switch that
  changes the floor tile pattern.
  [[Video]](https://clips.twitch.tv/CrunchyBlushingHummingbirdMingLee)
- Skip a key door and miniboss in D8 by switch hooking a darknut to clip
  through a block. [[Video]](https://clips.twitch.tv/RudeExcitedFerretWoofer)

##### Bonus round

This is **not** in logic because you could softlock, but it's a neat trick:

- Pass through the rock on the west side of Lynna City by switching with the
  Octorok. Clipping slightly into the fence tiles makes it slightly easier;
  using scent seeds to attract the Octorok makes it faster.
  [[Video]](https://imgur.com/vqk16pi)

### Seasons

#### Normal logic

- Jumping over 2 tiles with feather, 3 tiles with feather + pegasus seeds, 4
  tiles with cape, or 6 tiles with cape + pegasus seeds (subtract 1 tile if the
  jump is over water or lava instead of a pit)
- Using only ember seeds from the seed satchel as a weapon
- Using only ember, scent, or gale seeds from the slingshot as a weapon
- Using expert's ring as a weapon
- Using thrown objects (bushes, pots) as weapons
- Flipping spiked beetles using the shovel
- Farming ore chunks

#### Hard logic

- Anything that gives an explicit in-game warning (these are also potential
  softlocks)
- Required damage (damage boosts, falling in pits)
- Farming rupees using the shovel (large rupees can be RNG manipulated)
- Getting a new type of mystical seed from anything other than a seed tree
  (Subrosia market, D4, D5, D7, D8)
- Getting initial bombs from regenerating plants
- Lighting up to 2 torches using mystery seeds
- Using only scent or gale seeds from the seed satchel as a weapon
- Using fist ring as a weapon
- Carrying bushes or pots between rooms
- Poe skip
- Fighting Frypolar without slingshot
- D8 sidescrollers without cape
- Jumping between north and south Subrosia using cape without pegasus seeds

#### Out of logic

- Warnings
- Farming rupees without a shovel
- Lighting more than two torches per room using mystery seeds
- Mystery seeds as a weapon
- Bombs as a weapon, except versus enemies immune to sword
- Double damage boosts
- Trading seeds in Subrosia Market without having a seed item
- Swimming against currents without Swimmer's Ring
- Magic rings from non-randomized locations
- Linked secrets

#### Strategy guide

##### Overworld

- RNG manip 100-rupee drops using the shovel, for infinite rupees in logic.
  Hard reset, mash through the title screen (it rolls RNG every frame), make 7
  screen transitions, and dig until the 100-rupee drop. Make sure not to delay
  the dig after the Rope, since the Rope also rolls RNG periodically.
  [[Video]](https://imgur.com/NH4Vwbd)
- Access the chest in the Eastern Suburbs cave using a bomb + feather jump.
  [[Video]](https://imgur.com/pIL3Yqh)
- Cross the easternmost pits in Natzu Wasteland using a bomb + seeds + feather
  jump. [[Video]](https://imgur.com/9hT04QH)
- Reach Moblin Keep in Natzu Wasteland using only feather to clear pits.
  [[Video]](https://streamable.com/e9okj)
- Cross the Moblin Keep pool using a bomb + cape jump. Position yourself above
  and to the right of the bomb, and hold right as you jump.
  [[Video]](https://imgur.com/bYwxJjV)
- Cucco clip: reach the cave below the Spring Banana tree by grabbing the Cucco
  through the corner – move straight right into the rock before the screen
  transition so that the rock pushes you downward. This only matters if you
  have gale seeds to warp out.
  [[Video]](https://gfycat.com/negativeclumsyafricanfisheagle)
- Jump to the vanilla Dragon Key location using only cape.
  [[Video]](https://imgur.com/fILXdPC)
- Jump to the Subrosia portal in Horon Village using seeds + cape.
  [[Video]](https://imgur.com/elOp0hn)
- Cornerwalk across the gaps in the house on the Western Coast in order to
  reach the stump. In the second room, only move diagonally for a moment, then
  hold right. To get back, reenter and walk straight up.
  [[Video]](https://imgur.com/7Fi2LWy)
- Access the western stump in Temple Remains without autumn, using seeds +
  cape. [[Video]](https://imgur.com/SXQvM8b)
- Hit the lever in the floodgate keeper's house by throwing a pot. The
  horizontal position of the throw is precise.
  [[Video]](https://clips.twitch.tv/ExpensiveAbnegateMoonFUNgineer)

##### Subrosia

- Bomb jump between the market and furnace areas.
  [[Video]](https://imgur.com/YCQk2vr)

##### Dungeons

- Throw bushes in D1 to kill Goriya and hit the minecart lever.
  [[Video]](https://imgur.com/mrFmfkq)
- Throw pots in D2 to access the vanilla bracelet chest and blade trap room.
  [[Video]](https://imgur.com/TwtKSWS)
- Hit minecart levers in D4 by dropping pots while passing by. This works for
  both 1F minecarts.
  [[Video]](https://clips.twitch.tv/LaconicYawningPresidentFUNgineer)
- Fight the D4 boss (Gohma) using ember seeds or scent seeds from the seed
  satchel. [[Video]](https://www.youtube.com/watch?v=hXcSwAE86mE)
- Pegasus + feather jump to reach the left chest in D5 (no bomb boost
  required). [[Video]](https://clips.twitch.tv/CredulousTemperedMulePicoMause)
- Bomb + feather jump across the water to get to the minecarts in D5.
  [[Video]](https://imgur.com/iwOlNER)
- Damage boost off enemies to cross D5 sidescroller gaps without feather.
  [[Video]](https://imgur.com/LO7HqWf)
- Jump through the "wall" of fire traps in D5.
  [[Video]](https://imgur.com/MV7RBH4)
- Corner-walk around the first crystal in D6, or just run through the blade
  traps, obviating feather or a means to break the crystal.
- Poe skip: skip fighting the first Poe in D7.
  [[Video]](https://imgur.com/NC1AVV2)
- Bomb jump capeless to the button before the D7 miniboss.
  [[Video]](https://clips.twitch.tv/CloudyGoodReubenOneHand)
- Hit the three buttons in D7 in the correct order without pegasus seeds, by
  jumping on the edges of the tiles.
  [[Video]](https://imgur.com/8PvpNlV)
- Hit the first eye statue in D8 with seeds + feather + satchel.
  [[Video]](https://imgur.com/yJnKZ18)
- Hit sets of three eye statues in D8 with feather + satchel/slingshot instead
  of HSS. Only ember and scent seeds are in logic with the slingshot.
  [[Video]](https://imgur.com/gFFV97x)
- Activate the D8 bridge switch without L-2 boomerang or seeds + cape.
  [[Video]](https://imgur.com/IpnfKtE)

## Multiworld

The randomizer can generate interconnected seeds that can be played
simultaneously with other players on BizHawk. Each player's items are
distributed across all the files generated by a single seed, and a player's
items that are not in their own game are sent to them via the network.

### Instructions

1. Follow the BizHawk Co-op Netplay setup instructions at
   https://github.com/TestRunnerSRL/bizhawk-co-op#Setup
2. Place Oracles.lua in the bizhawk-co-op/ramcontroller/ folder
3. Generate a seed using the command line. A valid invocation looks like:
   `oracles-randomizer.exe -multi s,a+t,s+hdp`, run in the directory containing
   your vanilla ROMs.
4. Follow the rest of the instructions in the bizhawk-co-op readme to play the
   game.

### Notes and limitations

- Collecting items while disconnected from other players is not recommended.
- Seasons files can't contain Ages-exclusive items even if those items go to
  other players, and vice versa.
- Rings and shops, as well as a select few other item locations, will always
  belong to the local player.
- The treasure map in Seasons only displays the locations of your own jewels.
  Jewels that aren't in your game have sparkles at the Tarm gate instead.
- Finishing a multiworld game (i.e. defeating Onox or Veran) doesn't set
  postgame flags, since they would make some item locations inaccessible.
- Up to 99 players for a single seed are supported.
- Multiworld does not support linked games or plandos.

## Plandos

A "plando", or planned randomizer game, can be generated by providing a partial
or complete spoiler log as input to the randomizer. If the spoiler log is
partial (or empty!), the other variables are left vanilla, with the exception
of the ring pool, which is still random for unspecified rings. The names in the
log may be external spoiler log names (like "wooden/noble sword") or internal
ones (like "sword").

Currently the only way to create a plando is via the `-plan` command-line
option. Multiworld plandos are not supported.

### `-- items --` section

The number of each item need not match the vanilla distribution, although due
to technical limitations there may not be more rings than usual, and there can
be only one type of flute. Spheres and divisions between progression items /
keys / etc do not need to be specified. Any of the usual item section names can
also be used in place of `-- items --`.

### `-- dungeon entrances --` section

Multiple entrances can technically link to the same dungeon, but each dungeon
can only have one exit, which is randomly chosen from its entrances.

### `-- subrosia portals --` section

Seasons only. Multiple Holodrum portals linking to the same Subrosia portal
will have the same issue that dungeon entrances do.

### `-- default seasons --` section

Seasons only. No special notes.

## Known issues

- If tree wrap is turned off, it is possible to become stuck in Eyeglass Lake by
  using Rosa or an animal companion.
- If tree warp is turned off, it is possible to become stuck on Crescent Island
  by arriving on the raft and using a time portal.
- Bombing the Temple Remains Subrosian volcano while on a date with Rosa can
  cause issues.
- The chest game in the bought-out member's shop does not work properly.
- The cutscene where Nayru is saved from Veran has a graphical glitch.
- Multiworld: resynchronization after disconnection may not work properly,
  depending on whether Lua state was reset/lost.
- Multiworld: it is possible to avoid picking up an incoming item by pulling a
  bomb on the same frame and leaving the screen.
- Multiworld: Talon's mushroom (unrandomized, from the Seasons trading sequence)
  may go to the wrong player.
- Linked: logic does not account for the changed accessibility of the Piratian
  Captain item location.
- Linked: Tingle may not prompt for secrets.

## Credits

Thanks to:

- Stewmath for [oracles-disasm](https://github.com/Stewmath/oracles-disasm) and
  additional code.
- Herreteman, dragonc0, Phoenomenom714, and jaysee87 for help with logic,
  playtesting, design, and "customer support".
- Everyone who helped playtest prerelease versions of the randomizer!
