#!/usr/bin/env python3

state = 'init'

from re import compile

release_start = compile(r'^(?:oos|oracles)-randomizer ([^ ]+)$')
release = None
version = None
date = None
notes = []

with open('releases.txt') as f:
	for line in f.readlines():
		line = line.strip()
		if state == 'init':
			if (m := release_start.match(line)):
				release = m.group(0)
				version = m.group(1)
				state = 'release'
		elif state == 'release':
			date = line
			state = 'date'
		elif state == 'date':
			if line == release:
				state = 'notes'
				notes = []
		elif state == 'notes':
			if line == 'Assets':
				state = 'init'
				if '-' in version:
					continue
				print('##', version)
				print()
				print(date)
				print()
				spaced = True
				for note in notes:
					if note.endswith(';'):
						note = note.replace(';', ':')
					if note.endswith(':'):
						if not 'since' in note and note != 'General changes:':
							if not spaced:
								print()
							note = note.rstrip(':')
							print('###', note.replace('-specific changes', ''))
							print()
							spaced = True
					elif note != 'General changes':
						if note:
							print('-', note)
							spaced = False
				print()
			elif line != 'Latest':
				notes.append(line)
		else:
			assert(false)


