# Building and contributing to oracles-randomizer

If you plan to build the randomizer from source or contribute to development,
here are some things to know:


## Building

Building the randomizer used to be a fairly complicated process. Now just
`go build` should be sufficient.


## Branches

There are three main branches in the repository:

- **master**, which is for tagged release versions and documentation changes.
- **patch**, which is for bugfixes.
- **dev**, which is for new features or other major changes and may not be
  fully functional.

Other branches for specific features may branch off **dev** to be merged back
into **dev** later. If you intend to make a pull request, make sure to base
your changes on the appropriate branch. Also ask in advance unless you're
making a simple bugfix. *Also* also run `go test ./randomizer/` to make sure
tests pass before making commits.


## Organization

Go code is in `randomizer/`, but some types of changes don't even need to touch
the Go code. Logic is in `logic/`, GBC assembly code is in `asm/`, owl hint
names are in `hints/`, and various ROM addresses and values are in `romdata/`.
All the non-Go directories use YAML, although sometimes the contents of the
YAML amount to something more like a domain-specific language.


## Code style

Always run `go fmt ./randomizer/` before commits (note that `go fmt` coerces
all line-initial indentation to tabs). Wrap lines (in Go and YAML) at 80
characters when possible, assuming 8-space tabs for Go. YAML is necessarily
indented using spaces; the standard varies between 2 and 4 spaces, depending on
the conventions of the directory.
