# Oracles Randomizer version history

## 4.2.0

Dec 27, 2025

- Update Lua implementation to fix a vulnerability
- Distribute a user manual with release builds
- Layout location checklist in columns for easier reading
- Distribute builds for more architectures

### Seasons

- Remove a pit in Eyeglass Lake to help prevent softlocks outside D5
- New hard logic: jumping between north and south Subrosia with cape doesn't
  require bombs

### Ages

- Fix logic: Stalfos aren't attracted to scent seeds
- New logic: Pop Tingle's balloon with fist/expert's rings
- New logic: Tune of Ages can be used to access Tokay bomb cave
- New hard logic: sword clink to get to D2 Thwomp shelf
- New hard logic: D8 darknut clip using switch hook, to skip miniboss and a key
  door

### Development

- Migrate code repository off GitHub
- Make building the randomizer much simpler

## 4.1.6

Nov 6, 2021

### Seasons

- Prevent softlock via the "reverse Temple Remains" route in portal shuffle by adding a walkable tile outside the door before the volcano is bombed.
- Fix contents of the first chest in linked Hero's Cave to match the second non-key item you would get from unlinked Hero's Cave.
- Fix logic for upper Temple Remains portal, which doesn't reset the season.

## 4.1.5

Jul 7, 2021

### Ages

- Fix D7 water level not resetting when exiting via the D2 present entrance in dungeon shuffle.

## 4.1.4

Apr 3, 2021

### Ages

- Change postgame respawn point to be valid even if the Maku Tree was never saved.
- Add lighting D1 torches with mystery seeds to hard logic.
- Add changing gel colors with mystery seeds to hard logic.

## 4.1.3

Oct 14, 2020

- Fix panics for some Windows users by switching TUI libraries to Tcell from Termbox.

## 4.1.2

Jun 9, 2020

- Fixed result of interactive seed prompt being ignored.

## 4.1.1

Jun 1, 2020

### Ages

- Fixed logic for Maku Tree to account for newly randomized Maku Path small key.

## 4.1.0

May 26, 2020

- Multiworld via BizHawk is now supported. See doc/multiworld.md for details.

### Seasons

- Some deep water in Spool Swamp in spring was replaced with shallow water in order to prevent default season softlocks.
- Cornerwalking around D6 crystals moved to hard logic.
- New hard logic: D8 triple eye statues with L-1 ember or scent slingshot (it was previously only in logic with satchel or L-2 slingshot).
- New hard logic: Hit levers in D4 and floodgate keeper's house by dropping and throwing pots.

### Ages

- The Maku Path small key is randomized (between its vanilla location and the basement).
- The "goron's hiding place" now has a cracked wall, and the "maku path basement" stairs are visible without pushing blocks.
- New hard logic: In D6 present, bomb jump and hit the floor tile switch with sword.
- New hard logic: Reverse Tingle cave with seed shooter.

## 4.0.A

Apr 20, 2020

- Yes, 4.0.A. The file select screen doesn't have room for more decimal digits.
- Merge code to accommodate the web patcher's Nayru player sprite.

### Seasons

- Fix logic for "D3 bombed wall chest"; no moldorm weapon is needed.
- Fix plando gen crashing on treasure map sparkles if jewels don't exist anywhere.

### Ages

- Logically require a weapon for the floormasters at "D8 1F chest".
- Fix logic for "D6 past wizzrobe chest"; cane can't kill wizzrobes.

## 4.0.9

Mar 2, 2020

### Ages

- Fix logic: require mermaid suit for D6 and D7 bosses.

## 4.0.8

Jan 20, 2020

### Seasons

- Fixed treasure map sparkle for "sunken city, summer cave".
- Fixed impossible jump (to D5 left chest) being in normal logic.

### Ages

- Added static pegasus seed drop to Moosh Nuun to prevent softlock.
- Added second safety portal to Symmetry City to preserve symmetry.

## 4.0.7

Dec 16, 2019

### Seasons

- Fixed bug where jumping down a cliff on the same frame as triggering a warning disabled menus and warps.

### Ages

- Letter of Introduction is now called "Goron Letter" for the purpose of not overflowing the shop text box.
- Fixed logic for Pumpkin Head.

## 4.0.6

Nov 5, 2019

### Seasons

- New hard logic: can jump to D5 left chest without cape.
- Fixed logic for using default spring in Eastern Suburbs to get to Sunken City.
- Fixed logic for using default winter in Spool Swamp to reach the cave.

### Ages

- Fixed logic for "goron dance, with letter".
- Fixed hard logic for scent seeds to account for dungeon shuffle; Ramrock scent seeds can now be in logic.

## 4.0.5

Sep 2, 2019

### Seasons

- Fixed feather not being hard logically required for D7 maze chest.

### Ages

- Fixed power glove not being logically required for D8 tile room.

## 4.0.4

Jul 29, 2019

### Seasons

- Removed snow pile outside D6, preventing softlock in default winter with no shovel or gale seeds if statue was pushed left.
- Removed linked cutscene triggered when entering D8. The cutscene took the player to D8 regardless of dungeon shuffle.

## 4.0.3

Jul 23, 2019

- Linked shops sell shields instead of the 30-rupee gasha seeds that they sell in vanilla.

### Seasons

- Linked treasure map displays correct jewel locations.

### Ages

- Fixed logic for two chests in D7.

## 4.0.2

Jul 9, 2019

### Seasons

- Fixed unsafe animal save points not being "corrected" when entering D2 and the Eastern Suburbs portal when dungeons / portals are shuffled.
- Fixed some overworld logic around Spool Swamp / Holodrum Plain.
- Fixed the floodgate keyhole logic thinking you needed a bomb jump to cross the bridge without cape or flippers.

## 4.0.1

Jul 5, 2019

- Plandomizer doesn't crash trying to set dungeon room flags if a boss key is nowhere.

### Ages

- Animal companions can be called on the western coast of Crescent Island.
- Added a trick to D4 hard logic: skip switch hook by taking the miniboss portal, bomb jumping from the first minecart track to the bridge, using cane to press the button downstairs, and breaking the pot using noble sword.
- Fixed logic for "zora's reward" and "goron elder" checks.

## 4.0.0

Jul 1, 2019

### General major changes

- Dungeon entrance shuffle is a new option.
- In Seasons, alternate D2 entrances are removed in dungeon shuffle seeds, and the internal stairs link directly instead. Sometimes this will make the chest(s) outside of D2 inaccessible, in which case they won't contain anything required. The treasure map accounts for shuffled dungeon entrances.
- In Ages, both D6 entrances are randomized. Entering randomized D7 without the mermaid suit (or even flippers) is fine, but surfacing isn't allowed. Link would just drown anyway.
- Hero's Cave and Maku Path entrances are not randomized.
- Owl hints are removed as a design decision.
- On the file select screen, select+right toggles music, and select+left toggles using the original GBC colors even when playing on a GBA (or something emulating one). By default, the games use brighter, less saturated colors when played on a GBA - this is the vanilla behavior. The static, ROM-level music on/off option has been removed.
- The new -plan command-line flag generates a "seed" from a spoiler log instead of vice versa. See doc/plando.md for details.
- Item fill is now back-to-front (assume all items, then iteratively place them in ways that don't invalidate the seed) instead of front-to-back (assume no items, then iteratively place them in ways that unlock further checks). All types of item share the same fill step; in previous versions dungeon-specific items (small keys, etc) were placed before regular ones.
- Logic no longer requires that every check be reachable, as long as the seed is completable. Member's card can be in the member's shop, library key can be in the library, etc. Small keys can be permanently locked behind key doors, but this does not affect the logic applied to other small keys in the same dungeon.
- The old men who take rupees are not considered penalties to the player's logical rupee total. Notably, this puts the 200-rupee old man in past Rolling Ridge Base in logic.
- Bombs are never considered a logical weapon, even in hard logic.
- Shops (including Subrosia Market) display correct text for randomized items.
- Search is much faster than before. Search will continue using its internal 64-bit PRNG state instead of using a new 32-bit seed if a search attempt fails, so all 32-bit seeds are valid.
- The file select screen displays information about the randomizer version, seed, and flags.
- Spoiler logs only display actual progression items in the "progression items" section, instead of displaying every item that isn't logically inert.
- The new -race command-line flag displays only the first three digits of the seed in the filename and file select screen, and does not generate a spoiler log.

### General minor changes

- Ember trees give an accurate text box when harvested for the first time.
- The internal global ROM checksum matches the ROM data. This doesn't make any difference on hardware, but some emulators warn about mismatched checksums.

### Seasons-specific major changes

- Subrosia portal shuffle is a new option. The treasure map accounts for shuffled portals.
- Farming ore chunks with a sustainable item (or via Subrosian dancing) is in normal logic, since everyone does it anyway.
- The spring flower blocking the D6 entrance is back (as in vanilla). It is removed permanently when cut, in order to prevent softlocks.
- The "first" star ore dig spot is possible again. It was disabled in previous versions as a workaround for a vanilla bug.
- Cucco clip is in hard logic.
- Capeless D7 is in hard logic.

### Seasons-specific minor changes

- In previous versions, items with asymmetric wide sprites couldn't be the Temple of Seasons item due to a technical limitation. Now they can.
- A ledge is added near the lower temple remains portal in order to prevent portal shuffle softocks.
- The arrangement of bushes on Rosa's portal screen has changed to more closely resemble vanilla.
- Having all four seasons after getting an item from a season tower doesn't trigger the "you have all four seasons" text.
- Rupee logic for the rupee rooms in D2 and D6 is more pessimistic, since the value of each rupee is random.
- The master diver removes the plaque from the player's inventory when giving his item.
- The radius for warning triggers is a bit larger, since it was possible to miss the triggers for Sunken City and HSS skip.
- The linked smithy secret gives the a shield upgrade instead of a second instance of the hard ore check.
- Fixed logic for getting to Goron Mountain from Blaino's gym.
- Fixed logic for crossing Eyeglass Lake with default summer.

### Ages-specific major changes

- The rupee in Maku Path is randomized.

### Ages-specific minor changes

- Talus Peaks has an additional Echoes portal in order to prevent softlocks.
- Ricky's and Moosh's Nuun Highlands layouts have an additional Echoes portal in order to prevent softlocks.
- Farming rupees for minigames is technically in logic, but this will rarely matter. This makes rupee logic for the shop and potion more straightforward.
- The Green Joy Ring is excluded from the randomized ring pool, since it's completely useless in Ages – it doubles the value of ore chunk drops.
- Removed Ralph encounter on Talus Peaks.
- Removed Nayru from hanging out in Lynna Village from the start.
- Fixed missing feather requirement for D8 miniboss logic.

### Development

- GBC instructions are written as assembly instead of machine code. The randomizer embeds an assembler to translate the code at runtime.
- The various Go "subpackages" are merged into one in order to make PRs easier, since Go does not support relative imports.
- A lot of static data (including assembly code) now exists in YAML files rather than Go literals.
- Detailed instructions for building the randomizer from source can be found in doc/contributing.md.

## 3.5.6

May 29, 2019

### Seasons

- Fix D4 pool item incrementing subindex after falling into the pool, in some cases changing the type of item.

### Ages

- Stalfos in Maku Path despawn permanently after progressing, to prevent softlocking by running out of ammunition.

## 3.5.5

May 12, 2019

### Seasons

- Non-randomized items aren't screwed anymore
- lol
- play 3.5.4 for a good laugh though

## 3.5.4

May 10, 2019

### Seasons

- Fix retries on D5 Armos chests – if the chests were opened in the wrong order, the randomized item was still marked as taken.

## 3.5.3

May 6, 2019

### Seasons

- Remove deep water in summer Eyeglass Lake to avoid softlock from default winter + summer rod + setting save point in east cave.
- Fix "sunken city, summer cave" location on treasure map.

## 3.5.2

May 2, 2019

### Ages

- Fix logic requirements for D2 moblin platform, D3 bridge chest, and hard mode D4 peace ring (this will never matter).

## 3.5.1

Apr 25, 2019

### Seasons

- Fixed rings giving season spirit text when found in vanilla sword chest.
- Added missing pegasus seed requirement in logic for capeless gloveless vanilla cape chest.
- Fixed nonviable linked game starts due to small key randomization: linked games now start with the first non-key item in unlinked Hero's Cave, and the linked Hero's Cave chest contains the other non-key item.

## 3.5.0

Apr 22, 2019

- Small key locations are randomized within dungeons. Small keys will not be arranged in a way that could render an area permanently inaccessible, even if that area would only contain another small key. Small keys cannot be hinted.
- The Horon Village and South Lynna seed trees cannot be hinted.
- Small keys, boss keys, and slates are listed separate from other progression items in the log file and are not considered sphere boundaries.
- Lines within log file "paragraphs" are sorted alphabetically.

### Seasons

- Poe Skip is fully in hard logic. The chest skipped by Poe Skip is considered logically locked by all five D7 small keys (even in normal logic).
- The log file lists the Treasure Map under "other items" instead of "progression items".
- Misc. logic fixes.

### Ages

- Randomizer alterations to key doors (in D1, D5, and D7) are removed.
- Leaving D7 resets the water level to its initial state.
- Fixed the "zora's reward" check being hinted as "Sea of Storms" instead of "Zora Village".
- New hard logic: using a bomb boost (with cane) in place of pegasus seeds (or feather) in order to reach the "D2 thwomp shelf" check.
- Misc. logic fixes.

## 3.4.1

Apr 8, 2019

- Fixed arrangement of rings and hints being non-deterministic with respect to the given seed.

### Seasons

- Fixed two chests in D5 displaying the wrong location on the treasure map.

## 3.4.0

Apr 1, 2019

- Owl statues give "hints" about item locations when activated. See owls.md for information on owl rules.
- New techniques are included in hard logic for each game. Specific tricks are documented in seasons_hard_guide.md and ages_hard_guide.md, with video examples where they may be helpful.

### Seasons

- The rules for Subrosia portals displayed by the treasure map are changed: Subrosia locations are displayed as the nearest portal by number of screen transitions, with ties broken by earliest portal accesssible in vanilla.
- The magnet ball north of the D6 spinner is back in its vanilla location, since the key locked by it was required in logic anyway.
- Hard logic jumps across the L-shaped gap in Subrosia now require bombs in logic, since they're (probably) subpixel dependent without bomb boosts or cape.
- Throwing bushes, pots, etc. at targets in the same room is in normal logic instead of hard logic, as in Ages.
- Fixed Lost Woods check being inaccessible in a linked game if L-3 sword had been obtained.
- Fixed different pegasus seed requirements for D7 boss key chest in normal logic versus hard logic.

### Ages

- Rang Ring L-1 and L-2 are excluded from the ring pool, since they only work with the L-2 boomerang.
- Deku Forest tree access with punch rings (hard logic)
- D3 boss in normal logic
- D4 boomerang trick 2 (hard logic)
- D5 2-statue key
- Different vulnerabilities for normal gels and color gels
- Moosh Nuun cave without flute

## 3.3.7

Feb 26, 2019

### Seasons

- Add weapon check for D3 moldorm chest logic.

### Ages

- Allow getting quest from Symmetry City wife after Tuni Nut is placed.

## 3.3.6

Feb 12, 2019

### Seasons

- Bracelet can't be on Medusa Head.

### Ages

- Hitting the switch in the cave beneath Tingle using boomerang + feather + pegasus seeds or bombs is in hard logic.

## 3.3.5

Feb 4, 2019

### Seasons

- Prevent game from deleting Dimitri and Moosh dismount points in Sunken City and Mt. Cucco if you have flippers or D5 essence. Respectively.
- Fix Moosh being accessible on Mt. Cucco without spring banana if it's a Moosh seed and you don't have the flute.

### Ages

- Fix lava juice Goron setting the chest in his room to open after trading.
- Fix D7 not being properly locked behind King Zora in logic.

## 3.3.4

Jan 22, 2019

### Ages

- Fix linked Sea of Storms change from wreaking havoc on other tile substitutions (such as the D6 past door).

## 3.3.3

Jan 21, 2019

### Seasons

- Fix 150-rupee shop item not being available in linked games.

### Ages

- Rename "ridge base east present" to "ridge west top present" in spoiler log and checklist.
- Fix collection behavior of D2 boss item.
- Make Sea of Storms past accessible in linked games without Tune of Ages—the Zora guard is present in both eras, instead of a whirlpool in the past.

## 3.3.2

Jan 16, 2019

### Seasons

- Fixed sword and shield upgrades from shop/market working incorrectly.
- Fixed unspecified behavior of item from chest in linked Hero's Cave.

## 3.3.1

Jan 15, 2019

- Fixed L-3 seed satchel capacity.

### Ages

- Fixed D2 essence always warping you to the past entrance, even if it's closed.
- Moved the great fairy on the linked D2 present screen out of the way of the entrance.

## 3.3.0

Jan 14, 2019

- Heart containers are randomized.
- Beta linked support is implemented, but has not been extensively tested. A seed is completeable in the same way unlinked and linked; the only substantial change is that linked Seasons files start with the first item from unlinked Hero's Cave. Linked elements are not randomized, and are not in logic—the only real goal is that linked games should be completable.

### Seasons

- Add logic for Eyeglass Lake portal access using only Dimitri, feather, and winter (default or rod).
- Add logic for D5 access via resetting the season to default autumn using the Eyeglass Lake portal.

### Ages

- Slates are randomized within D8.
- Rings in the 150-rupee shop check correctly display identified text.

## 3.2.1

Jan 8, 2019

### Seasons

- Fix Holodrom Plain east old man being in logic incorrectly.
- Gleeok with bombs is not in hard logic, because it's not actually possible with 10 bombs. This will never matter.

### Ages

- Fix Nayru being in logic incorrectly.

## 3.2.0

Jan 7, 2019

- New files start with a L-3 ring box, and the ring list can be accessed via the ring box icon in the inventory menu. Rings are automatically appraised when obtained.
- Randomized rings also use a randomized ring pool, instead of using strictly the vanilla rings that were in the randomized locations. Trophy rings (those that have no effect at all) are excluded from the pool.
- Rings obtained from randomized locations are in logic. Fist Ring, Expert's Ring, and Energy Ring can be progression in both games. Swimmer's Ring and Toss Ring can be progression only in Seasons.
- The Fist and Expert's rings can be used with only one item slot unequipped instead of both.

### Seasons

- The item in the Mt. Cucco cave under the Spring Banana tree is randomized.
- The Horon Village tree is considered a valid warp point regardless of whether it's been visited. This matches the South Lynna tree's behavior in Ages.
- Fixed logic for the D5 magnet ball chest, Rosa's portal, hitting levers from a minecart, the Spring Banana tree, Natzu Wasteland, the old men in Holodrum Plain and Woods of Winter, and navigation from southwest to south central Subrosia.
- Accessing the Eastern Suburbs moblin cliff chest without either cape or magnet gloves is hard logic instead of normal logic.

### Ages

- Using boomerang for the D3 bridge room is hard logic instead of normal logic.
- Using cane + pegasus seeds for the D2 thwomp shelf is hard logic instead of normal logic.
- Using a shovel for Patch's restoration ceremony is hard logic instead of being out of logic.
- The gravestones outside Cheval's grave can no longer be jumped over, since there is no reason to do grave jump (access without Moosh).
- The D6 present compass displays the vanilla boss key chest on the map. It doesn't in the vanilla game.
- "D8 isolated chest" is renamed to "D8 ghini chest".

## 3.1.5

Dec 29, 2018

- Disable credits music when music is set to off.

### Seasons

- Fix logic: Sunken City is accessible via Moblin Keep without feather in Dimitri's Natzu layout.
- Add ledge to Eyeglass Lake portal island in summer to prevent softlocking in default summer without feather.

### Ages

- Center the worker in Ricky's Nuun layout on a tile for convenience.

## 3.1.4

Dec 19, 2018

### Seasons

- Fix logic for shield in Subrosia Market: it costs ember seeds, not ore chunks.
- Remove pits in southwest Spool Swamp to prevent a softlock in default winter.

## 3.1.3

Dec 16, 2018

### Ages

- Stop Cheval Rope from erasing animal companion save point when acquired.

## 3.1.2

Dec 14, 2018

- Force specific ordering of a ROM table in order to produce consistent checksums.

### Ages

- Fix logic prereqs for Fairies' Woods, breaking crystals (ember seeds work, but only in Ages), Cheval's Grave (hard logic only), and Crescent Island tree (can get warp point by swimming under island, hard logic only).
- Add dormant portal outside D2 present to allow return to the past in the case of using a Currents return portal and save/death-warping back to the entrance. Also, change the conditions for which age the D2 exit leads to, such that a save point in that situation won't be stuck in a wall.

## 3.1.1

Dec 13, 2018

### Ages

- Fixed various overworld logic.

### Seasons

- Fixed D6 chest names.

## 3.1.0

Dec 6, 2018

- Search is now single-threaded instead of multithreaded, in order to eliminate bias toward seeds that compute more quickly.
- Many cutscenes are removed or abbreviated, and some dialogue is removed.

### Seasons

- Non-tree non-dungeon mystical seed sources work correctly in hard difficulty.

### Ages

- Visiting the Maku Tree in the present is not required to rescue the Maku Tree in the past.
- Buying a shield without being given rupees is never in logic.
- The D3 bridge chest can be accessed in logic using boomerang and "backdoor" tactics.
- The NPC standing outside D2 is centered on a tile, preventing currents return portal breakage.

## 3.0.1

Dec 3, 2018

- Using Dimitri to get seeds from Dimitri-accessible trees is in logic.
- Made a variety of minor logic fixes.

### Seasons

- The HSS skip warning does not appear if the player has taken the normal route to its location.

### Ages

- Patch's ceremony with items other than sword is in normal logic if you have the cane.
- Shadow Hag with ember seeds from seed satchel is in normal logic instead of hard logic, not that it currently matters.
- Added a ledge near the library in the past, allowing escape from Zora Village if the player gets there without gale seeds or fairy powder.

## 3.0.0

Nov 19, 2018

- Ages support is implemented, so it's oracles-randomizer instead of oos-randomizer. See the readme and the links therein for details.
- The randomizer has a new UI, allowing option selection without using the command line. This change should also allow macOS users to use method 1 from the readme, just as Windows users can.
- Tree warp can either be fully enabled with no cooldown, or fully disabled. Since there is never a cooldown, tree warp no longer sets your save point.
- Log files now list items by sphere instead of by fill order, where sphere 0 is set the items you can obtain from the start, sphere 1 is the set of items you can obtain using the sphere 0 items, and so on. In order to make the progression easier to read, the "progression items" section lists all potential progression items instead of only strictly required ones.
- Dungeon chests in the log file now use location-based names instead of names based on their vanilla contents.
- Basic HTML item trackers for both games are included in the randomizer download.

### General logic

- Rupee logic is 1. fixed and 2. more conservative, accomodating for scenarios where multiple rupee-locked items could be progression, but only one immediately is.
- Shovel RNG manips for rupees are now in hard logic.
- Using bombs as a weapon specifically versus Armos is now in normal logic, since it's required in vanilla Ages.
- Using your starting seeds from the seed satchel / slingshot / seed shooter without being able to collect more from trees is now in hard logic, as long as you can at least break bushes to get more seeds.

### Seasons

- Poe skip is now in hard logic as long as you have magnet gloves (since you could softlock by doing Poe skip if magnet gloves are in the first chest in D7). This is only in logic for skipping the Poe fight, not the key, in order to prevent keylocks. You will still receive a warning after doing Poe skip if you do not have magnet gloves and have not gone through the first key door.
- A few logic bugfixes.

## 2.2.0

Oct 14, 2018

- Two difficulty settings: normal difficulty (default) is easier than the previous default; hard difficulty (specified with -hard on the command line) is more difficult; see link in readme for details
- Technical limitations on which items can appear in which locations no longer apply
- Gate in front of Maku Tree requires sword to open (as in vanilla)
- Type of duplicate mystical seed tree is randomized
- Treasure map displays actual jewel locations
- Compass beeps in actual room containing boss key
- Moosh on Mt. Cucco requires spring banana even if you have his flute (as in vanilla)
- All known plausible softlocks are handled in-game rather than in-logic (D2 area in winter, D5 in not-autumn, D7 in winter, Poe skip without magnetic gloves, taking Dimitri outside Sunken City without flute)
- -update flag is removed since 2.2 is incompatible with previous versions
- Many logic fixes and optimizations

## 2.1.4

Oct 3, 2018

- Fix vanilla bug where dismounting an animal companion on the D1 entrance screen allowed entry without the Gnarled Key
- Replace deep water tiles outside D4 to prevent softlock if exiting without flippers or default summer
- Ban magnet gloves from the first chest in D7, since Poe skip could lead to a softlock otherwise
- Reinstate a cannon on Moblin Keep (removal was never necessary)
- Change logic; lighting the second Poe sister's torches with HSS as a substitute for pegasus seeds is in

## 2.1.3

Sep 30, 2018

- Fix small keys not playing sound effect when picked up
- Fix the way Blaino "unequips" your active ring, since it was effectively changing the friendship ring into the dev ring
- Fix D7 logic: don't need pegasus seeds to light torches

## 2.1.2

Sep 28, 2018

- Move bushes outside the Eastern Suburbs portal so that it's possible to leave and reenter Subrosia without breaking them
- Fix Subrosia Market giving random rings (often resulting in out-of-bounds ring IDs) instead of specific randomized rings
- Make refilling all seeds a property of the seed satchel instead of a property of the Member's Shop
- Use cape graphics for stolen "feather" if cape is stolen

## 2.1.1

Sep 25, 2018

- Fix logic for tower of summer
- Fix vanilla bug of being to dig up star-shaped ore multiple times on first screen

## 2.1.0

Sep 23, 2018

- Randomize D4 and D5 boss keys
- Implement progressive item upgrades for sword, boomerang, slingshot, feather/cape, and seed satchel: the first you pick up will always be L-1, and the second will always be L-2
- Make item placement "more random" in that all items have equal chances (given technical limitations) of being placed in available locations, unless only one location remains
- Work around technical limitations in shop, member's shop, temple of seasons, Subrosian seaside, Subrosia market, master diver's reward, great furnace, and Subrosian smithy so that they can accommodate more items
- Fix seed displayed in output and log file; 2.0.x displayed the initial seed in the thread instead of the final one
- Fix Maku Tree item disappearing if you leave and reenter without picking it up if you already have an item of that class

## 2.0.4

Sep 20, 2018

- Fix logic regarding safely reaching the Master Diver through Natzu River
- Fix Dimitri and Moosh not fully entering screen on bridge(s)
- Completely remove Dimitri and Moosh events from Spool Swamp
- Fix flute having an incorrectly reduced chance as a starting item
- Make miscellaneous minor logic changes

## 2.0.3

Sep 16, 2018

- Don't remove star-shaped ore when getting ribbon
- Don't remove red and blue ore when getting hard ore
- Do remove star-shaped ore when trading it in the market
- Fix dry Eyeglass Lake chest mixup in logic
- Move second magnet ball in D6 onto button to prevent softlock from misusing keys without magnet gloves
- Add D5 ember seed chest to logic

## 2.0.2

Sep 15, 2018

- Fix logic for hitting levers: throwing pots in the floodgate keeper's house doesn't work, but shovel does
- Fix non-unique items from being placed in the subrosia seaside slot, causing them to be unobtainable if the player already has the same item or an upgraded version of it
- Add -nomusic command-line flag just for https://streamable.com/k3vrs

## 2.0.1

Sep 14, 2018

- Fix spurious cliff warning appearing on screen leading to Maku Tree
- Move HSS skip warning to other side of pit, so that it doesn't interfere with performing HSS skip itself
- Remove "(optional)" items from log file, since they can be misleading, take extra time to compute, and weren't supposed to be in 2.0 in the first place

## 2.0.0

Sep 14, 2018

- The JP verson is no longer supported. The US version's Nintendo/Capcom screen can be skipped after 1 second, to match the JP version.
- There are new ways to run the randomizer that don't require using the command line: drag your vanilla ROM onto the executable, or put the ROM and executable in the same folder and just run it.
- One identified flute, randomly chosen between the three animal companions, is in the item pool. Ricky and the Subrosian Dance Hall don't give flutes. The layout of the Natzu region corresponds to the type of flute in the seed.
- Single-purchase items in the Shop, Member's Shop, and Subrosia Market are randomized.
- Boss key chests are randomized.
- Hard Ore and Iron Shield are randomized.
- The chest in the Master Diver's cave is randomized again, since it's not bugged in the US version.
- The cliff between the Natzu region and Woods of Winter is back to normal (no stairs, just a flower). A warning displays if the ledge is approached without the means to get back up. Equivalent warnings are displayed, if applicable, for the ledges approaching Sunken City from Mt. Cucco and Moblin Keep.
- Tree warp can only be used outdoors (in the overworld or in Subrosia) to prevent some strange behavior caused by warping indoors. Tree warp also sets the save point to the Horon Village seed tree.
- Ricky's Gloves are removed from the game, since it's very easy to softlock by using them. Sadly, this means yet another gasha seed in the item pool.
- An HTML item location checklist is included in the randomizer download.

### Minor changes

- The search algorithm has changed significantly: multiple items can be placed in one step, and items are distributed more evenly with regard to how many can be reached at each step in the progression. L-1 items are also more likely to be placed before L-2 items, and seed satchels are more likely to be placed before slingshots.
- Rupees are counted exactly, so that you will always have enough for the items required in logic without having to farm.
- The log file splits items into required and optional sections, and uses more descriptive names for locations and items.
- The diving spot at the south end of Sunken City exists again. The game displays a warning if you step into the diving spot without having the seasons needed to get back to Sunken City.
- The game also displays a warning for breaking bushes without having a sustainable way of doing so, and for HSS skip, since small keys obtained out of order can be misused in a way that leaves an area of the dungeon inaccessible.
- All known instances of "unsafely" using an animal to enter a cave or portal set the animal's save point to be accessible after exiting. Because of this, the flowers blocking the Spring Banana tree are present again in all seasons.
- Animal companions can be called on the D1 entrance screen.
- Spring currents in Spool Swamp are altered so that it's possible to swim back to Holodrum Plain.
- The chances of feather and cape appearing in the Hero's Cave sword chest are halved, since there are two of them. This matches the behavior for swords, rod seasons, and flutes.
- Some logic has changed: among other things, Roc's Cape is considered required or the ice sidescroller in D8, mystery seeds are considered sufficient to light most torches, and animal companions are considered sufficient for a lot of new things.
- The screen where the stolen feather is normally buried can be exited after the feather is picked up, not after the tile is dug.
- It's possible (but unlikely) for the seed satchel or slingshot to start with gale seeds. Using a gale seed in the overworld will have no effect on Link if no seed trees have been explored.
- Enemies spawn on the screen where Rosa is first encountered in the vanilla game.
- The two Maku Seed cutscenes (receiving it and using it) are abbreviated.
- Most item locations that were restricted by special sprite requirements are no longer restricted.
- The -keyonly mode (only randomizing key item slots) has been removed.

### Bugfixes

- Mismatched seed trees now regrow correctly.
- A lot of logic has been fixed, especially regarding what animal companions can do, what's possible given a certain Natzu region layout, and the mess that is Eyeglass Lake.

### Other notes

- Herreteman has developed an oos-randomizer item and location tracker plugin for EmoTracker.
- I won't be working as much on randomizer features for a while. Ages support will probably be the first priority when I return to it. Patch versions for 2.0 bugfixes will of course still happen as needed.

## 1.5.8

Aug 30, 2018

- Fix the last overworld season carrying over after the Piratian cutscene

## 1.5.7

Sep 13, 2018

- Remove chest in master diver's room from the random pool due to a bug in the vanilla JP version
- Remove flower on the way to spring banana tree to avoid softlock
- Undo a change from 1.5.6, un-removing a snow pile since an animal companion can just be called from the previous screen
- Remove obsolete softlock checks associated with altered game areas
- Add some animal companion abilities to logic (but not to required logic)

## 1.5.6

Aug 25, 2018

- Save animal position adjacent to certain entrances that could lead to softlock if accessed by means of an animal that's then left behind
- Remove check preventing Moosh from appearing in the mountains if the player has the D4 essence
- Remove a snow pile in Eastern Suburbs west of the mystery tree, allowing animal companions to enter from the right when called

## 1.5.5

Aug 24, 2018

- Make stolen feather appear above ground instead of buried, allowing retrieval without shovel (replacing bugged lock-area-behind-shovel logic)
- Ensure consistent order of operations in ROM changes so that the same seed actually gives the same checksum

## 1.5.4

Aug 23, 2018

- Fix freewarp being enabled by default in JP
- Make minor logic change for Moblin's Keep

## 1.5.3

Aug 21, 2018

- Give fool's ore collection text to stop it from hanging the game when collected from a map or compass chest

## 1.5.2

Aug 20, 2018

- Fix logic for the D8 ring chest, D3 map and compass chests, and two overworld chests
- Check for softlocks related to entering D5 in one season and exiting in another
- Fix a bug found by the one and only Phoenomenom714
- Fix a bug in the JP version related to digging up the item replacing star-shaped ore

## 1.5.1

Aug 19, 2018

- Fix softlock from doing hide and seek first, having feather stolen second

## 1.5.0

Aug 19, 2018

- Support both JP and US versions of the game
- Add all chests except for small key and boss key chests to the randomization pool
- Old mode is available with the -keyonly command line flag
- Make season spirits give random items, and allow seasons can be found in chests, in the form of the rod plus one season
- Stop L-1 sword from giving a blank item that still takes up an inventory slot
- Require player to talk to the pirate ghost to make the desert skull appear if the ship hasn't left
- Move Talon and his mushroom so they don't block the chest in their cave
- Fix some logic and softlock cases

## 1.4.3

Aug 15, 2018

- Prevent softlock from entering D2 area without shovel or feather+bracelet when Eastern Suburbs defaults to winter

## 1.4.2

Aug 15, 2018

- Prevent gale seeds from coming with the satchel (and consequentially slingshot), since attempting to warp without having explored any seed trees will hang the game

## 1.4.1

Aug 14, 2018

- Replace the stairs on the Eyeglass Lake island with a railing in summer, preventing a screen transition to the Noble Sword screen

## 1.4.0

Aug 14, 2018

- Add tree warp as a softlock escape mechanism (see readme for details)
- Skip intro sequence and pirate cutscene
- Fix bugs with desert and master diver (not) giving item upgrades
- Change logic to handle possible sequence breaks
- Fix some logic in general, particularly related to animal companions
- Boomerang L-1 and shovel are no longer possible starting items
- Likelihood of sword as a starting item halved, since there are two
- When possible, heart pieces are put in chests instead of downgrades
- Add -seed flag for deterministic output
- Multithread route finding
- Don't print spoilers to terminal unless -verbose flag is given
- Remove -devcmd and -dryrun flags

## 1.3.4

Aug 12, 2018

- Prevent softlock from reaching the Square Jewel chest without a shovel

## 1.3.3

Aug 11, 2018

- Replace rock flower outside of D6 with bush (prevents softlock)

## 1.3.2

Aug 10, 2018

- Make pirate skull always present in desert, removing the sequence restriction on rusty bell
- Stop L-1 slingshot from being slotted without unlocking anything
- Add some logic

## 1.3.1

Aug 10, 2018

- Changes since 1.3.0
- Fix square jewel chest logic

## 1.3.0

Aug 10, 2018

- Randomize default season for each area
- Make mystical seeds grow in all seasons
- Add stairs to the cliff between Eastern Suburbs and Sunken City
- Remove overworld Rosa event and activate her portal from the start
- Remove lever in Natzu that creates bridge, blocking waterway
- Add softlock check for entering D7 without shovel in winter
- Fix some graph logic

## 1.2.2

Aug 8, 2018

- Remove diving spot at the south end of Sunken City (softlock)
- Resize Sokra's trigger area in Horon Village (softlock)
- Move magnet ball in D8 one tile away from stairs (pseudo-softlock)
- Remove snow piles in front of shovel house, replacing item restriction
- Strip spaces from goal/forbid args and validate before randomizing

## 1.2.1

Aug 3, 2018

- Add -update flag
- Remove third master diver essence check
- Fix poe curse bug
- Add accurate map icons for seed trees
- Fix some routing data

## 1.2.0

Aug 3, 2018

- Randomize rod of seasons, L-2 sword, and fool's ore
- Fool's ore is not given by the Subrosians
- Seed trees and initial satchel/slingshot seeds are randomized
- Slingshot can be used without obtaining a satchel
- Hero's cave fade-to-white cutscene is back
- Eastern Commons defaults to spring, not autumn (to avoid softlocks)
- Magic rings are not randomized (for now, to avoid softlocks)
- Prevent obtaining the rusty bell before talking to the pirate captain
- Randomizer produces a log file summarizing the item placement
- Improvements to the routing algorithm

## 1.1.0

Jul 28, 2018

- Require all 8 essences to get the Maku Seed
- Still allow getting the strange flute after visiting north of D1
- Improve performance of softlock checks

## 1.0.1

Jul 27, 2018

- Prevent softlock from having feather stolen before getting shovel

## 1.0.0

Jul 27, 2018

- First release (randomizer is "complete")
